/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.desertmobs.entity;

import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.core.entity.EntityCreatureTameable;
import com.lycanitesmobs.core.entity.ai.EntityAIAttackRanged;
import com.lycanitesmobs.core.entity.ai.EntityAIFollowOwner;
import com.lycanitesmobs.core.entity.ai.EntityAILookIdle;
import com.lycanitesmobs.core.entity.ai.EntityAISwimming;
import com.lycanitesmobs.core.entity.ai.EntityAITargetAttack;
import com.lycanitesmobs.core.entity.ai.EntityAITargetOwnerAttack;
import com.lycanitesmobs.core.entity.ai.EntityAITargetOwnerRevenge;
import com.lycanitesmobs.core.entity.ai.EntityAITargetOwnerThreats;
import com.lycanitesmobs.core.entity.ai.EntityAITargetRevenge;
import com.lycanitesmobs.core.entity.ai.EntityAIWander;
import com.lycanitesmobs.core.entity.ai.EntityAIWatchClosest;
import com.lycanitesmobs.core.info.DropRate;
import com.lycanitesmobs.desertmobs.entity.EntityThrowingScythe;
import java.util.HashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityClink
extends EntityCreatureTameable
implements IMob {
    private EntityAIAttackRanged rangedAttackAI;

    public EntityClink(World world) {
        super(world);
        this.attribute = EnumCreatureAttribute.UNDEFINED;
        this.defense = 0;
        this.experience = 5;
        this.hasAttackSound = false;
        this.setWidth = 0.6f;
        this.setHeight = 1.8f;
        this.setupMob();
        this.attackPhaseMax = (byte)3;
        this.justAttackedTime = (short)10;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming(this));
        this.rangedAttackAI = new EntityAIAttackRanged(this).setSpeed(0.75).setRate(10).setRange(14.0f).setMinChaseDistance(4.0f);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.rangedAttackAI);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.aiSit);
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIFollowOwner(this).setStrayDistance(4.0).setLostDistance(32.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWander(this));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest(this).setTargetClass(EntityPlayer.class));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAILookIdle(this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAITargetOwnerRevenge(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAITargetOwnerAttack(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAITargetRevenge(this).setHelpCall(true));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityPlayer.class));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityVillager.class));
        this.field_70715_bh.func_75776_a(6, (EntityAIBase)new EntityAITargetOwnerThreats(this));
    }

    @Override
    protected void func_110147_ax() {
        HashMap<String, Double> baseAttributes = new HashMap<String, Double>();
        baseAttributes.put("maxHealth", 15.0);
        baseAttributes.put("movementSpeed", 0.24);
        baseAttributes.put("knockbackResistance", 0.0);
        baseAttributes.put("followRange", 16.0);
        baseAttributes.put("attackDamage", 0.0);
        super.applyEntityAttributes(baseAttributes);
    }

    @Override
    public void loadItemDrops() {
        this.drops.add(new DropRate(new ItemStack(ObjectManager.getItem("throwingscythe")), 1.0f).setMinAmount(2).setMaxAmount(7));
        this.drops.add(new DropRate(new ItemStack(Items.field_151042_j), 0.1f).setMinAmount(1).setMaxAmount(3));
    }

    @Override
    public void rangedAttack(Entity target, float range) {
        EntityThrowingScythe projectile = new EntityThrowingScythe(this.field_70170_p, (EntityLivingBase)this);
        projectile.setProjectileScale(2.0f);
        projectile.field_70163_u -= (double)(this.field_70131_O / 4.0f);
        float accuracy = 2.0f * (this.func_70681_au().nextFloat() - 0.5f);
        double d0 = target.field_70165_t - this.field_70165_t + (double)accuracy;
        double d1 = target.field_70163_u - (double)target.field_70131_O * 0.25 - projectile.field_70163_u + (double)accuracy;
        double d2 = target.field_70161_v - this.field_70161_v + (double)accuracy;
        float f1 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2)) * 0.2f;
        float velocity = 1.2f;
        projectile.func_70186_c(d0, d1 + (double)f1, d2, velocity, 6.0f);
        this.func_184185_a(projectile.getLaunchSound(), 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_72838_d((Entity)projectile);
        this.nextAttackPhase();
        if (this.getAttackPhase() == 2) {
            this.rangedAttackAI.setRate(60);
        } else {
            this.rangedAttackAI.setRate(10);
        }
        super.rangedAttack(target, range);
    }

    @Override
    public boolean isDamageTypeApplicable(String type) {
        if (type.equals("cactus")) {
            return false;
        }
        return super.isDamageTypeApplicable(type);
    }

    @Override
    public boolean func_70687_e(PotionEffect potionEffect) {
        if (potionEffect.func_188419_a() == MobEffects.field_76438_s) {
            return false;
        }
        if (potionEffect.func_188419_a() == MobEffects.field_76437_t) {
            return false;
        }
        return super.func_70687_e(potionEffect);
    }

    @Override
    public boolean petControlsEnabled() {
        return true;
    }
}

